---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Robustness (diagnostic)

> Maintains Form under bounded shocks; no loss of identity or closure.

---

## Definition

- Shock tolerance capacity
- Form preservation ability
- Identity retention power
- Disturbance resistance

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Shock handle | Load spike | `Monitor`, `Shock` |
| Form hold | State keep | `Check`, `Form` |
| Identity keep | Pattern hold | `Test`, `Keep` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Shock handle | Takes hits | "Stays strong" |
| Form hold | Keeps shape | "Holds together" |
| Identity keep | Stays self | "Remains true" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Load spike | Takes hits | How shock works |
| State keep | Keeps shape | How form holds |
| Pattern hold | Stays self | How identity lasts |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Load handle | Force resist |
| Networks | Fault handle | Link hold |
| Cognition | Pattern keep | Mind hold |
| Systems | State keep | Flow hold |

---

## Scale Effects

How Robustness manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum hold | Wave keep |
| λV | Gate resist | State hold |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase hold | Pattern keep |
| ∇S | Structure resist | Clear hold |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave hold | Light keep |
| λV | Field resist | Space hold |

Note: At extreme scales, robustness faces fundamental limits (e.g., quantum uncertainty at ε, causal resistance at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: shock threshold met
- c: load capacity held
- ψA: phase preserved
- λV: gates stable

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern hold | Wave keep |
| Human | λV | Gate resist | Flow hold |
| Cosmic | ψA | Phase keep | Field hold |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Form break | Pattern loss | Lost shape |
| Human | Identity loss | Self break | Lost self |
| Cosmic | Field break | Structure loss | Lost hold |

---

## Diagnostic Checklist

Technical tests:
- [ ] Shock handled
- [ ] Form preserved
- [ ] Identity kept
- [ ] State stable

Humane tests:
- [ ] Takes hits well
- [ ] Shape holds
- [ ] Self remains
- [ ] Core stable

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical resilience nor experiential strength alone captures its full meaning.

---

## See Also

- [[Stability Margin (diagnostic)]]
- [[Resilience (diagnostic)]]
- [[Brittleness (diagnostic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented